<?php 
require_once('../include/Session.php');
require_once('../include/Crud.php');
require_once("../include/Controller.php");

$Controller = new Controller();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get the form data
    $kc_username = $_POST['kc_username'];
    $password = $_POST['password'];

    // Verify the user
    $user = $Controller->verifyUser($kc_username, $password);

    if  (is_array($user) && array_key_exists('user_id', $user)){

        $_SESSION['user_id'] = $user['user_id']; 
        header("Location: index.php"); 
        exit();
    } else {
        // User authentication failed, show error message
        $_SESSION['errorMsg'] = "Login Failed, Try Again Later.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Login</title>
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no" />
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="" name="author" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico" />
    <!-- App css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/jquery-ui.min.css" rel="stylesheet" />
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/metisMenu.min.css" rel="stylesheet" type="text/css" />
    <link href="../plugins/daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
</head>

<body class="dark-sidenav">
    <!-- Left Sidenav -->

    <!-- end left-sidenav-->
    <div class="page-wrapper">
        <!-- Top Bar Start -->

        <!-- Top Bar End --><!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="row">
                                <div class="col">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item">
                                        </li>
                                        <li class="breadcrumb-item">
                                        </li>
                                    </ol>
                                </div>
                                <!--end col-->
                                <div class="col-auto align-self-center">

                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </div>
                        <!--end page-title-box-->
                    </div>
                    <!--end col-->
                </div>
                <!--end row--><!-- end page title end breadcrumb -->
                <div class="row">

                    <!--end col-->
                </div>
                <!--end row-->
                <div class="row">
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-header">

                                <h4 class="">Welcome to the Healing School Staff Portal</h4>
                                <!-- <span></span> -->
                                <?php
echo errorMsg();
echo successMsg();
echo infoMsg();

?>

                            </div>
                            <!--end card-header-->
                            <div class="card-body">
                                <form method="POST">
                                    <div class="form-group">
                                        <label for="">KingsChat Username</label>
                                        <input type="text" class="form-control"  name="kc_username" />
                                    </div>
                                    <div class="form-group">
                                        <label for="">Password</label>
                                        <input type="password" class="form-control" name="password"/>
                                    </div>
                                    
                                    <button type="submit" class="btn btn-primary">
                                        Submit
                                    </button>
                                </form>
                            </div>
                            <!--end card-body-->
                        </div>
                        <!--end card-->
                    </div>

                    <!--end col-->
                </div>


                <!--end row-->
            </div>
            <!-- container -->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper --><!-- jQuery  -->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/metismenu.min.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/simplebar.min.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/moment.js"></script>
    <script src="../plugins/daterangepicker/daterangepicker.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
</body>

</html>