<?php 
require_once('../include/Session.php');
require_once('../include/Functions.php');
require_once('../include/Crud.php');
require_once("../include/Controller.php");

$Controller = new Controller();

$user_id = $_SESSION['user_id'];

$current_form_number = 8;

$form_check_result = $Controller->fmCheckOd($_SESSION['user_id']);

// Check if $form_check_result is not null and if it has at least one element
if ($form_check_result !== null && isset($form_check_result[0]['form_check'])) {
    $form_check = $form_check_result[0]['form_check'];

    // Cast $form_check to an integer
    $form_check = (int)$form_check;

    // var_dump($form_check); 
    if ($form_check === $current_form_number) {
        header("Location: index.php");
        exit();
    }
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $para_no =  stripslashes($_POST["para_no"]);
    $para_nam =  stripslashes($_POST["para_nam"]);
    $st_port_id =  stripslashes($_POST["st_port_id"]);
    $car =  stripslashes($_POST["car"]);
    $user_id =  $_POST["user_id"];

    try {
        $data = [
            "form_check" => 8,
            "para_no" => $para_no,
            "para_nam" => $para_nam,
            "st_port_id" => $st_port_id,
            "car" => $car,
            "user_id" => $user_id,
        ];
        $lastInsertedId = $Controller->createOd($data);
        if ($lastInsertedId) {
            $_SESSION['od_id'] = $lastInsertedId;
            $_SESSION['staff_od'] = true;
        
            $_SESSION["successMsg"] = "Successfully registered";
            // JavaScript code to redirect after 5 seconds
            echo '<script>
                    setTimeout(function() {
                        window.location.href = "index.php"; 
                    }, 1000); 
                  </script>';
            exit(); 
        }
        
    } catch (PDOException $e) {
        // Handle database errors
        $_SESSION['errorMsg'] = "Database error: " . $e->getMessage();
      } catch (Exception $e) {
        // Handle unexpected exceptions
        $_SESSION['errorMsg'] = "An unexpected error occurred: " . $e->getMessage();
      }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Healing School | Staff Portal</title>
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no" />
    <meta content="Staff Portal For Healing School" name="description" />
    <meta content="" name="author" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico" />
    <!--Form Wizard-->
    <link rel="stylesheet" href="../plugins/jquery-steps/jquery.steps.css" />
    <!-- App css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/jquery-ui.min.css" rel="stylesheet" />
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/metisMenu.min.css" rel="stylesheet" type="text/css" />
    <link href="../plugins/daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <link href="../plugins/timepicker/bootstrap-material-datetimepicker.css" rel="stylesheet" />
</head>

<body class="dark-sidenav">
    <!-- Left Sidenav -->
    <?php
    include_once ("../components/sidenav.php");
    ?>
    <!-- end left-sidenav-->
    <div class="page-wrapper">
        <!-- Top Bar Start -->
        <?php
        include_once ("../components/topbar.php"); 
        ?>

        <!-- Top Bar End --><!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="row">
                                <div class="col">
                                    <h4 class="page-title">Staff Portal</h4>
                                    <ol class="breadcrumb">

                                        <li class="breadcrumb-item">
                                            <a href="javascript:void(0);">Staff Portal</a>
                                        </li>
                                        <li class="breadcrumb-item active">Forms</li>
                                    </ol>
                                </div>
                                <!--end col-->
                                <div class="col-auto align-self-center">
                                    <a href="#" class="btn btn-sm btn-outline-primary" id="Dash_Date"><span class="day-name" id="Day_Name">Today:</span>&nbsp;
                                        <span class="" id="Select_date">Jan 11</span>
                                        <i data-feather="calendar" class="align-self-center icon-xs ml-1"></i> </a>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </div>
                        <!--end page-title-box-->
                    </div>
                    <!--end col-->
                </div>
                <!--end row--><!-- end page title end breadcrumb -->
                <?php
                echo errorMsg();
                echo successMsg();
                echo infoMsg();

                ?>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Staff Form</h4>
                                <p class="text-muted mb-0">Please ensure all details are filled out before submitting.
                                    <i class="mdi mdi-heart text-danger"></i>

                                </p>
                            </div>
                            <!--end card-header-->
                            <div class="card-body">
                                <form id="form-horizontal form" class="form-horizontal form-wizard-wrapper" method="POST">

                                    <h3>Other Details</h3>
                                    <fieldset>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Parallex Acct. No.</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="para_no" type="number" class="form-control" required />
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">

                                                    <label for="" class="col-lg-3 col-form-label">Parallex Acct Name</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="para_nam" type="text" class="form-control" required />

                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Staff Portal ID</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="st_port_id" type="text" class="form-control" required />
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">

                                                    <label for="" class="col-lg-3 col-form-label">Car</label>
                                                    <div class="col-lg-9 d-flex">
                                                        <div class="custom-control col-lg-3">
                                                            <input type="checkbox" class="custom-control" id="" name="car" value="Official" />
                                                            <label class="" for="">Official</label>
                                                        </div>
                                                        <div class="custom-control col-lg-3">
                                                            <input type="checkbox" class="custom-control" id="" name="car" value="Personal" />
                                                            <label class="" for="">Personal</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <div class="col-lg-9">
                                                        <input id="" value="<?=$_SESSION['user_id']?>" name="user_id" type="hidden" class="form-control" />
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                        </div>
                                    </fieldset>
                                    <!--end fieldset-->
                                    <div class="button-items" style="float:right">
                                        <script>
                                            // Function to store the current page URL in session storage
                                            function storePreviousPage() {
                                                sessionStorage.setItem('previousPage', window.location.href);
                                            }

                                            // Function to redirect the user to the previous page
                                            function redirectToPreviousPage() {
                                                var previousPage = sessionStorage.getItem('previousPage');
                                                if (previousPage) {
                                                    window.location.href = previousPage;
                                                } else {
                                                    window.location.href = '../index.php';
                                                }
                                            }
                                        </script>

                                        <button type="button" class="btn btn-outline-secondary btn-square btn-skew waves-effect waves-light" onclick="redirectToPreviousPage()">
                                            <span>Previous</span>
                                        </button>
                                        <button type="submit" class="btn btn-outline-primary btn-square btn-skew waves-effect waves-light" onclick="storePreviousPage(); document.getElementById('form').submit();">
                                            <span>Finish</span>
                                        </button>

                                    </div>
                                </form>
                                <!--end form-->
                            </div>
                            <!--end card-body-->
                        </div>
                        <!--end card-->
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->

                <!--end row-->
            </div>
            <!-- container -->
            <?php include_once('../components/footer.php') ?>
            <!--end footer-->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper --><!-- jQuery  -->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/metismenu.min.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/simplebar.min.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/moment.js"></script>
    <script src="../plugins/daterangepicker/daterangepicker.js"></script>
    <!-- App js -->
    <script src="assets/js/app.js"></script>
</body>

</html>