<?php 
require_once('../include/Session.php');
require_once('../include/Functions.php');
require_once('../include/Crud.php');
require_once("../include/Controller.php");

$Controller = new Controller();
$dbConnection = new DbConnection();
$conn = $dbConnection->getConnection();

$user_id = $_SESSION['user_id'];

$current_form_number = 1;

// Get the form check result from the database for the current user
$form_check_result = $Controller->fmCheckSd($_SESSION['user_id']);

// Check if $form_check_result is not null and if it has at least one element
if ($form_check_result !== null && isset($form_check_result[0]['form_check'])) {
    $form_check = $form_check_result[0]['form_check'];

    // Cast $form_check to an integer
    $form_check = (int)$form_check;

    // var_dump($form_check); 
    if ($form_check === $current_form_number) {
        header("Location: ed.php");
        exit();
    }
}

$getUserbyId = $Controller->getUserById($_SESSION['user_id']);
// var_dump($getUserbyId);
// die();


if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
  $title = stripslashes($_POST["title"]);
  $first_name = stripslashes($_POST["first_name"]);
  $middle_name = stripslashes($_POST["middle_name"]);
  $last_name = stripslashes($_POST["last_name"]);
  $phone_no = stripslashes($_POST["phone_no"]);
  $kc_username = stripslashes($_POST["kc_username"]);
  $email = stripslashes($_POST["email"]);
  $off_email = stripslashes($_POST["off_email"]);
  $esp_username = stripslashes($_POST["esp_username"]);
  $d_o_b = stripslashes($_POST["d_o_b"]);
  $form_check = stripslashes($_POST["form_check"]);

  if (empty($title) || empty($first_name) || empty($middle_name) || empty($last_name)) {
      $_SESSION['errorMsg'] = "Missing required fields";
  } else {
      try {
          $user = $Controller->updateUser(
              $user_id,
              $title,
              $first_name,
              $middle_name,
              $last_name,
              $phone_no,
              $kc_username,
              $email,
              $off_email,
              $esp_username,
              $d_o_b,
              $form_check
          );

          if ($user) {
              // $_SESSION['successMsg'] = "User information updated successfully!";
              // redirect_to('ed.php');
          } else {
              // $_SESSION['errorMsg'] = "Failed to update user information";
              $_SESSION['successMsg'] = "User information updated successfully!";
              redirect_to('ed.php');
          }
      } catch (PDOException $e) {
          // Handle database errors
          $_SESSION['errorMsg'] = "Database error: " . $e->getMessage();
      } catch (Exception $e) {
          // Handle unexpected exceptions
          $_SESSION['errorMsg'] = "An unexpected error occurred: " . $e->getMessage();
      }
  }
}


// var_dump($_POST);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <title>Healing School | Staff Portal</title>
  <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no" />
  <meta content="Staff Portal For Healing School" name="description" />
  <meta content="" name="author" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <!-- App favicon -->
  <link rel="shortcut icon" href="assets/images/favicon.ico" />
  <!--Form Wizard-->
  <link rel="stylesheet" href="../plugins/jquery-steps/jquery.steps.css" />
  <!-- App css -->
  <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
  <link href="assets/css/jquery-ui.min.css" rel="stylesheet" />
  <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
  <link href="assets/css/metisMenu.min.css" rel="stylesheet" type="text/css" />
  <link href="../plugins/daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
  <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
  <link href="../plugins/timepicker/bootstrap-material-datetimepicker.css" rel="stylesheet" />
</head>

<body class="dark-sidenav">
  <!-- Left Sidenav -->
  <?php 
  include_once ("../components/sidenav.php");
   ?>
  <!-- end left-sidenav-->
  <div class="page-wrapper">
    <!-- Top Bar Start -->
    <?php 
    include_once ("../components/topbar.php"); 
    ?>

    <!-- Top Bar End --><!-- Page Content-->
    <div class="page-content">
      <div class="container-fluid">
        <!-- Page-Title -->
        <div class="row">
          <div class="col-sm-12">
            <div class="page-title-box">
              <div class="row">
                <div class="col">
                  <h4 class="page-title">Staff Portal</h4>
                  <ol class="breadcrumb">

                    <li class="breadcrumb-item">
                      <a href="javascript:void(0);">Staff Portal</a>
                    </li>
                    <li class="breadcrumb-item active">Forms</li>
                  </ol>
                </div>
                <!--end col-->
                <div class="col-auto align-self-center">
                  <a href="#" class="btn btn-sm btn-outline-primary" id="Dash_Date"><span class="day-name"
                      id="Day_Name">Today:</span>&nbsp;
                    <span class="" id="Select_date">Jan 11</span>
                    <i data-feather="calendar" class="align-self-center icon-xs ml-1"></i> </a>
                </div>
                <!--end col-->
              </div>
              <!--end row-->
            </div>
            <!--end page-title-box-->
          </div>
          <!--end col-->
        </div>
        <!--end row--><!-- end page title end breadcrumb -->
                <?php
                echo errorMsg();
                echo successMsg();
                echo infoMsg();

                ?>
        <div class="row">
          <div class="col-sm-12">
            <div class="card">
              <div class="card-header">
                <h4 class="card-title">Staff Form</h4>
                <p class="text-muted mb-0">Please ensure all details are filled out before submitting.

                </p>
              </div>
              <!--end card-header-->
              <div class="card-body">
                <form id="form-horizontal" class="form-horizontal form-wizard-wrapper" method="POST">
                  <h3>Staff Details</h3>
                  <fieldset>
                  <input id="" value="<?=$_SESSION['user_id']?>" name="user_id" type="hidden" class="form-control" />
                  <input id="" value="1" name="form_check" type="hidden" class="form-control" />

                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="title" class="col-lg-3 col-form-label">Title</label>
                          <div class="col-lg-9">
                            <input id="" value="<?=$getUserbyId[0]["title"]?>" name="title" type="text"class="form-control" required />
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="first_name" class="col-lg-3 col-form-label">First Name</label>
                          <div class="col-lg-9">
                            <input id="" value="<?=$getUserbyId[0]["first_name"]?>" name="first_name" type="text" class="form-control"required />
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                    </div>
                    <!--end row-->
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="middle_name" class="col-lg-3 col-form-label">Middle Name</label>
                          <div class="col-lg-9">
                            <input id="" value="<?=$getUserbyId[0]["middle_name"]?>" name="middle_name" type="text" class="form-control" required />
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="last_name" class="col-lg-3 col-form-label">Last Name</label>
                          <div class="col-lg-9">
                            <input id="" value="<?=$getUserbyId[0]["last_name"]?>" name="last_name" type="text" class="form-control" required/>
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                    </div>
                    <!--end row-->
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="phone_no" class="col-lg-3 col-form-label">Phone No.</label>
                          <div class="col-lg-9">
                            <input type="text" id="" value="<?=$getUserbyId[0]["phone_no"]?>" name="phone_no" class="form-control" required>
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="kc_username" class="col-lg-3 col-form-label">KingsChat Username</label>
                          <div class="col-lg-9">
                            <input type="text" id="" name="kc_username" value="<?=$getUserbyId[0]["kc_username"]?>" class="form-control" required>
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                    </div>
                    <!--end row-->
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="email" class="col-lg-3 col-form-label">Email Address</label>
                          <div class="col-lg-9">
                            <input id="" name="email" value="<?=$getUserbyId[0]["email"]?>" type="text" class="form-control" required/>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="off_email" class="col-lg-3 col-form-label">Official Email Address</label>
                          <div class="col-lg-9">
                            <input id="" name="off_email" type="text" value="<?=$getUserbyId[0]["off_email"]?>" class="form-control" required/>
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                    </div>
                    <!--end row-->
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group row">
                          <label for="esp_username" class="col-lg-3 col-form-label">Espees Username</label>
                          <div class="col-lg-9">
                            <input id="" name="esp_username" type="text" value="<?=$getUserbyId[0]["esp_username"]?>" class="form-control" required/>
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                      <div class="col-md-6">
                        <div class="form-group row">

                          <label for="" class="col-lg-3 col-form-label">Date of Birth</label>
                          <div class="col-lg-9">
                            <input id="" name="d_o_b" type="date" class="form-control" value="<?=$getUserbyId[0]["d_o_b"]?>" required/>
                            
                          </div>
                        </div>
                        <!--end form-group-->
                      </div>
                      <!--end col-->
                    </div>
                    <!--end row-->
                  </fieldset>
                  <div class="button-items" style="float:right">
                    <button type="submit" class="btn btn-outline-primary btn-square btn-skew waves-effect waves-light">
                      <span>Next</span>
                    </button>
                    
                  </div>
                  <!--end fieldset-->
                  
                  <!--end fieldset-->
                </form>
                <!--end form-->
              </div>
              <!--end card-body-->
            </div>
            <!--end card-->
          </div>
          <!--end col-->
        </div>
        <!--end row-->

        <!--end row-->
      </div>
      <!-- container -->
      <?php include_once ('../components/footer.php') ?>
      <!--end footer-->
    </div>
    <!-- end page content -->
  </div>
  <!-- end page-wrapper --><!-- jQuery  -->
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/js/bootstrap.bundle.min.js"></script>
  <script src="assets/js/metismenu.min.js"></script>
  <script src="assets/js/waves.js"></script>
  <script src="assets/js/feather.min.js"></script>
  <script src="assets/js/simplebar.min.js"></script>
  <script src="assets/js/jquery-ui.min.js"></script>
  <script src="assets/js/moment.js"></script>
  <script src="../plugins/daterangepicker/daterangepicker.js"></script>
  <!-- <script src="../plugins/jquery-steps/jquery.steps.min.js"></script>
  <script src="assets/pages/jquery.form-wizard.init.js"></script> -->
  <!-- App js -->
  <script src="assets/js/app.js"></script>
</body>

</html>